## 복원 순서 개요

### 복구 `dump` [minio](minio.rsonesoft.com) 접속 후 `db-backups` bucket 참조

복원은 다음 순서대로 진행합니다:

1. 글로벌 객체 복원: 사용자, 권한, 테이블스페이스 등 (선택 사항)  
2. 데이터베이스 생성: 각 `.dump` 파일 대상 DB를 사전에 생성  
3. 데이터베이스 복원: `pg_restore`를 이용해 덤프 파일 복원

---

## 1. 글로벌 객체 복원 (globals.sql)

글로벌 객체에는 사용자 계정, 권한, 테이블스페이스 등의 설정이 포함됩니다.  
기존에 동일한 객체가 존재할 경우 오류가 발생할 수 있으므로 상황에 따라 생략 가능합니다.

```bash
psql -U postgres -f /path/to/your/backup/globals.sql
```

---

## 2. 데이터베이스 생성 및 복원

백업받은 각 `.dump` 파일에 대해 아래의 과정을 반복합니다.

### 예시: `db1.dump` 복원

1) 빈 데이터베이스 생성

```bash
createdb -U postgres db1
```

2) pg_restore 명령어를 이용한 복원

```bash
pg_restore -U postgres -d db1 /path/to/your/backup/db1.dump
```

병렬 처리를 통해 복원 속도를 개선할 수 있습니다. 시스템의 코어 수에 맞게 `-j` 옵션을 조정하십시오.

```bash
pg_restore -U postgres -d db1 -j 4 /path/to/your/backup/db1.dump
```

- `-j`: 병렬 작업 수 지정 (예: 4)
- 병렬 복원은 `pg_dump -Fc` 또는 `directory` 포맷에서만 사용 가능

---

### 추가 예시: `db2.dump` 복원

```bash
createdb -U postgres db2
pg_restore -U postgres -d db2 -j 4 /path/to/your/backup/db2.dump
```

---

## 3. 복구 결과 확인

데이터베이스 복원 완료 후 다음 명령어를 통해 확인할 수 있습니다:

```bash
psql -U postgres -l
```

또는 특정 데이터베이스에 직접 접속하여 점검합니다:

```bash
psql -U postgres -d db1
```
