// 설정값 링크: http://www.gisdeveloper.co.kr/?p=12587
// 요청경로 참고: 네이버 + 카카오 맵, 대구 2d 지도 서비스

// RsMapCore 네이버 설정
this.__getLayerNaverMap = function (tileType){
	proj4.defs('EPSG:3857', '+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs');
	ol.proj.setProj4 = proj4;

	var resolutions = [78000, 39000, 19600, 9800, 4900, 2400, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135];
	var extent      = [-20037508.342789244, -20037508.342789244, 20037508.342789244, 20037508.342789244];  // 4 * 3

	var projection = new ol.proj.Projection({
		code: 'EPSG:3857',
		extent: extent,
		units: 'm'
	});

	var _id = this.ServiceType.BaseLayer.name + '-naver-' + tileType;
	var tileLayer = new ol.layer.Tile({
		id : _id,
		title : 'Naver ' + tileType + ' Map',
		visible : false,
		type : 'base',
		source : new ol.source.XYZ({
			projection: projection,
			crossOrigin : "anonymous",
			tileSize: 256,
			tilePixelRatio: 1.5, // 타일 이미지 화질 (1 ~ 2)
			minZoom: 0,
			maxZoom: resolutions.length - 1,
			tileGrid: new ol.tilegrid.TileGrid({
				extent: extent,
				origin: [extent[0], extent[2]], // y축 역배열 보정
				resolutions: resolutions
			}),
			tileUrlFunction: function (tileCoord, pixelRatio, projection) {
				if (tileCoord == null) return undefined;

				var z = tileCoord[0] + 1;
				var x = tileCoord[1];
				var y = tileCoord[2] + 1; // y축 보정값


				if (tileType === 'Base') {
					// 기본지도
					//  * only http 요청만 -> return '//nrbe.map.naver.net/styles/basic/1717723233/' + z + '/' + x + '/' + -y + '@2x.png?mt=bg.ol.sw.ar.lko'; 
					return '//map.pstatic.net/nrb/styles/basic/1717723233/' + z + '/' + x + '/' + -y + '@2x.png?mt=bg.ol.sw.ar.lko'; // mt= 파라미터 삭제 시 피쳐 x
				} else {
					// 항공지도
					// * only http 요청만 -> return '//nrbe.map.naver.net/styles/satellite/1717723233/' + z + '/' + x + '/' + -y + '@2x.png?mt=bg.ol.sw.ar.lko';
					return '//map.pstatic.net/nrb/styles/satellite/1717723233/' + z + '/' + x + '/' + -y + '@2x.png?mt=bg.ol.sw.ar.lko'; // mt= 파라미터 삭제 시 피쳐 x
				}
			}
		})
	});

	return tileLayer;
};

// RsMapCore 카카오 설정
this.__getLayerDaumMap = function (tileType){
	proj4.defs("EPSG:5181","+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
	ol.proj.setProj4 = proj4;
	
	var resolutions = [2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1, 0.5, 0.25];
	var extent      = [-30000, -60000, 494288, 988576];

	var projection = new ol.proj.Projection({
		code: 'EPSG:5181',
		extent: extent,
		units: 'm'
	});
	
	var _id = this.ServiceType.BaseLayer.name + '-daum-' + tileType;
	var tileLayer = new ol.layer.Tile({
		id : _id,
		title : 'Daum Street Map',
		visible : false,
		type : 'base',
		source : new ol.source.XYZ({
			projection: projection,
			tileSize: 512,
			tilePixelRatio: 1.5, // 타일 이미지 화질 (1 ~ 2)
			minZoom: 0,
			maxZoom: resolutions.length - 1,
			tileGrid: new ol.tilegrid.TileGrid({
				origin: [extent[0], extent[1]],
				resolutions: resolutions
			}),
			tileUrlFunction: function (tileCoord, pixelRatio, projection) {
				if (tileCoord == null) return undefined;

				var s = Math.floor(Math.random() * 4);  // 0 ~ 3
				var z = resolutions.length - tileCoord[0];
				var x = tileCoord[1];
				var y = tileCoord[2];

				// 카카오는 http, https 둘 다 가능
				// https가 적용된 웹페이지에서는 http 요청 자동으로 https로 업그레이드
				var _tileUrl = 'http://map.daumcdn.net/map_k3f_prod/bakery/image_map_png/PNG01/v29_9jh91/' + z + '/' + y + '/' + x + '.png';
				if (tileType === 'Satellite') {
					_tileUrl = 'http://map' + s + '.daumcdn.net/map_skyview_hd/L' + z + '/' + y + '/' + x + '.jpg?v=160107'; // 카카오는 피쳐레이어 별도로 제공
				} else if (tileType == 'Roadview') {
					_tileUrl = 'http://map.daumcdn.net/map_k3f_prod/bakery/image_map_png/PNG_RV01/v16_fs8a9/' + z + '/' + y + '/' + x + '.png';
				}

				return _tileUrl;
			}
		})
	});

	return tileLayer;
};