#!/bin/bash

GEOSERVER_URL="http://your.geoserver.com/geoserver"
USERNAME="user_name"
PASSWORD="your_password"
WORKSPACE="your_workspace"

# 현재 폴더 내의 모든 sld 파일 업로드
for FILE in *.sld; do
  if [[ -f "$FILE" ]]; then
    STYLE_NAME="${FILE%.*}"

    echo "Uploading style: $STYLE_NAME"

    # 1단계: 스타일 메타 등록
    curl -u "$USERNAME:$PASSWORD" -X POST \
      -H "Content-Type: application/xml" \
      -d "<style><name>$STYLE_NAME</name><filename>$STYLE_NAME.sld</filename></style>" \
      "$GEOSERVER_URL/rest/workspaces/$WORKSPACE/styles"

    # 2단계: 실제 SLD 업로드
    curl -u "$USERNAME:$PASSWORD" -X PUT \
      -H "Content-Type: application/vnd.ogc.se+xml" \
      -T "$FILE" \
      "$GEOSERVER_URL/rest/workspaces/$WORKSPACE/styles/$STYLE_NAME"

    echo "Done: $STYLE_NAME"
    echo
  fi
done

