WITH land AS (
	SELECT 
		pnu,
		jibun,
		geom
	FROM lsmd_cont_ldreg 
	WHERE pnu LIKE '51760380%'
	AND RIGHT(jibun, 1) NOT IN ('도', '구', '천') 
), jukjung AS (
	SELECT 
		a.pnu,
		jukjung,
		jukjung1
	FROM filtered_customforest a
	INNER JOIN land ON a.pnu = land.pnu
), jaebe AS (
	SELECT 
		a.pnu,
		jaebe,
		jaebe1
	FROM filtered_shortterm_forestproduct a
	INNER JOIN land ON a.pnu = land.pnu
), namu AS (
	SELECT
		a.pnu,
		na_imsang,
		na_yunggub,
		na_kyunggub,
		na_mildo
	FROM filtered_foresttype a
	INNER JOIN land ON a.pnu = land.pnu
), toyang AS (
	SELECT
		a.pnu,
		to_jiri,
		to_jihyung,
		to_moam,
		to_tosim,
		to_yugi,
		to_tosung,
		to_geunsup,
		to_geunmildo
	FROM filtered_soil a
	INNER JOIN land ON a.pnu = land.pnu
), dem AS (
	SELECT 
		a.pnu,
		avg_height,
		avg_slope,
		avg_aspect
	FROM filtered_dem a
	INNER JOIN land ON a.pnu = land.pnu
)
SELECT
	land.pnu,
	land.jibun,
	ROUND((ST_Area(land.geom) / 10000)::NUMERIC, 2) AS area_hectare,
	jukjung,
	jukjung1,
	jaebe,
	jaebe1,
	na_imsang,
	na_yunggub,
	na_kyunggub,
	na_mildo,
	to_jiri,
	to_jihyung,
	to_moam,
	to_tosim,
	to_yugi,
	to_tosung,
	to_geunsup,
	to_geunmildo,
	avg_height,
	avg_slope,
	avg_aspect
FROM land
LEFT OUTER JOIN jukjung ON land.pnu = jukjung.pnu
LEFT OUTER JOIN jaebe ON land.pnu = jaebe.pnu
LEFT OUTER JOIN namu ON land.pnu = namu.pnu
LEFT OUTER JOIN toyang ON land.pnu = toyang.pnu
LEFT OUTER JOIN dem ON land.pnu = dem.pnu;